	window.onload = init;
	document.getElementById('btnclr1').onclick = newBoard;
	document.getElementById('btn1').onclick = answer;
	document.getElementById('btn2').onclick = check;
	var counter=1;
	var sc=1;
	var imageID = 'img'+ counter;
	var btnClr = document.getElementById('btnclr1');
	var btnReponses = document.getElementById('btn1');
	var btnValider = document.getElementById('btn2');
	var totalRows = 2;
	var totalColumns = 3;



function init() {
	document.getElementById("screen1").style.display = 'block';
	LoadNewImage(imageID);
	btnClr.disabled=true;
	btnClr.setAttribute('style', "color:#D4D0C8");
	btnValider.disabled=true;
	btnValider.setAttribute('style', "color:#D4D0C8");
	btnReponses.disabled=true;
	btnReponses.setAttribute('style', "color:#D4D0C8");
}


function newBoard (){
	if (counter < 3) {
		counter+=1;
	} else {
		counter = 1;
	}
	var screenElement = document.getElementsByClassName('screen');
	for(var i=1; i < screenElement.length+1; i++) {
		var screenElement1 = document.getElementById('screen'+i).style.display ='none';
	}
	sc = 1;
	btnClr.setAttribute('style', "color:#D4D0C8");
	btnValider.disabled=true;
	btnValider.setAttribute('style', "color:#D4D0C8");
	btnReponses.disabled=true;
	btnReponses.setAttribute('style', "color:#D4D0C8");
	document.getElementById('canJigsaw').style.display ='block';
	var screenElement2 = document.getElementById('screen'+counter).style.display = 'block';
	imageID = 'img'+ counter;
		if (counter == 2) {
		totalRows = 2;
		totalColumns = 2;
	} else { 
		totalRows = 2;
		totalColumns = 3;
	}
	LoadNewImage(imageID);
	var textElement = document.getElementsByClassName('no1');
	for(var i=1; i < textElement.length+1; i++) {
		var tb1 = document.getElementById('fill'+i);
		tb1.value='';
		tb1.removeAttribute('style');
		tb1.disabled = true;
	}
}
function answer (){
	var textElement = document.getElementsByClassName('no1');
	if (sc == 1) {
	for(var i=1; i < textElement.length+1; i++) {
		var que1 = document.getElementById('fill'+i);
		var ans1 = document.getElementById('e_'+i);
			que1.setAttribute('hidden', 'hidden');
			ans1.removeAttribute('hidden');
	}
	btnClr.disabled=true;
	btnClr.setAttribute('style', "color:#D4D0C8");
	btnValider.disabled=true;
	btnValider.setAttribute('style', "color:#D4D0C8");

		sc += 1;
	} else {
	for(var i=1; i < textElement.length+1; i++) {
		var que1 = document.getElementById('fill'+i);
		var ans1 = document.getElementById('e_'+i);
			que1.removeAttribute('hidden');
			ans1.setAttribute('hidden', 'hidden');
	}
	btnClr.disabled=false;
	btnClr.setAttribute('style', "color:#000000");
	btnValider.disabled=false;
	btnValider.setAttribute('style', "color:#000000");
		sc -= 1;
	}
}


function check (){
	sc = 1;
	var screenElement = document.getElementsByClassName('no1');
	for(var i=1; i < screenElement.length+1; i++) {
		var getAnswer = document.getElementById("fill"+i);
		var correctAns = document.getElementById("ans"+i);
		var getAnswertext = getAnswer.value.toLowerCase()
		if (getAnswertext == "poupée") {
			getAnswertext='poupee';
		}
		if (getAnswertext == correctAns.innerText.toLowerCase()) {
			getAnswer.setAttribute('style', 'color:#FFFFFF;background-color: #008000;');
		} else {
			getAnswer.setAttribute('style', 'color:#FFFFFF;background-color: red;');
		}
	}
	btnClr.disabled=false;
	btnClr.setAttribute('style', "color:#000000");
	btnValider.disabled=false;
	btnValider.setAttribute('style', "color:#000000");
	btnReponses.disabled=false;
	btnReponses.setAttribute('style', "color:#000000");
}

function LoadNewImage(imgID) {
    imageID = imgID;
    LoadGame();
}
function LoadGame() {
    var canvasID = "canJigsaw";
    game = new jigsaw(canvasID, imageID, totalRows, totalColumns);
    game.initDrawing();
}
function imageBlock(no, x, y) {
    this.no = no;
    this.x = x;
    this.y = y;
    this.isSelected = false;
}
function jigsaw(canvasID, imageID, rows, columns) {
    var MAIN_IMG_WIDTH = 600;
    var MAIN_IMG_HEIGHT = 400;
    var BLOCK_IMG_WIDTH = 300;
    var BLOCK_IMG_HEIGHT = 200;
    var TOTAL_ROWS = rows;// 4;
    var TOTAL_COLUMNS = columns;  //4;
    var TOTAL_PIECES = TOTAL_ROWS * TOTAL_COLUMNS;
    var IMG_WIDTH = Math.round(MAIN_IMG_WIDTH / TOTAL_COLUMNS);
    var IMG_HEIGHT = Math.round(MAIN_IMG_HEIGHT / TOTAL_ROWS);
    var BLOCK_WIDTH = 0; // Math.round(BLOCK_IMG_WIDTH / TOTAL_COLUMNS);
    var BLOCK_HEIGHT = 0; // Math.round(BLOCK_IMG_HEIGHT / TOTAL_ROWS);
    var image1;
    var canvas;
    var ctx;
    this.canvasID = canvasID;
    this.imageID = imageID;
    this.top = 0;
    this.left = 0;
    this.imageBlockList = new Array();
    this.blockList = new Array();
    this.selectedBlock = null;
    this.mySelf = this;
    this.initDrawing = function () {
        mySelf = this;
        selectedBlock = null;
        canvas = document.getElementById(canvasID);
        ctx = canvas.getContext('2d');
        // register events
        //canvas.ondblclick = handleOnMouseDbClick;
        canvas.onmousedown = handleOnMouseDown;
        canvas.onmouseup = handleOnMouseUp;
        canvas.onmouseout = handleOnMouseOut;
        canvas.onmousemove = handleOnMouseMove;
        image1 = document.getElementById(imageID);
        initializeNewGame();
    };
    function initializeNewGame() {
        // Set block
        BLOCK_WIDTH = Math.round(BLOCK_IMG_WIDTH / TOTAL_COLUMNS);
        BLOCK_HEIGHT = Math.round(BLOCK_IMG_HEIGHT / TOTAL_ROWS);
        // Draw image
        SetImageBlock();
        DrawGame();
    }
    function DrawGame() {
        clear(ctx);
        drawLines();
        drawAllImages();
        if (selectedBlock) {
            drawImageBlock(selectedBlock);
        }
    }
    function SetImageBlock() {
        var total = TOTAL_PIECES;
        imageBlockList = new Array();
        blockList = new Array();
        var x1 = BLOCK_IMG_WIDTH+10;
        var x2 = canvas.width-100;
        var y2 = BLOCK_IMG_HEIGHT-100;
        for (var i = 0; i < total; i++) {
            var randomX = randomXtoY(x1, x2, 2);
            var randomY = randomXtoY(0, y2, 2);
            var imgBlock = new imageBlock(i, randomX, randomY);
            imageBlockList.push(imgBlock);
            var x = (i % TOTAL_COLUMNS) * BLOCK_WIDTH;
            var y = Math.floor(i / TOTAL_COLUMNS) * BLOCK_HEIGHT;
            var block = new imageBlock(i, x, y);
            blockList.push(block);
        }
    }
    function drawLines() {
       ctx.strokeStyle = "#e9e9e9";
        ctx.lineWidth = 1;
        ctx.beginPath();
        // draw verticle lines
        for (var i = 0; i <= TOTAL_COLUMNS; i++) {
            var x = BLOCK_WIDTH * i;
            ctx.moveTo(x, 0);
            ctx.lineTo(x, 200);
        }
        // draw horizontal lines
        for (var i = 0; i <= TOTAL_ROWS; i++) {
            var y = BLOCK_HEIGHT * i;
            ctx.moveTo(0, y);
            ctx.lineTo(300, y);
        }
        ctx.closePath();
        ctx.stroke();
    }
    function drawAllImages() {
        for (var i = 0; i < imageBlockList.length; i++) {
            var imgBlock = imageBlockList[i];
            if (imgBlock.isSelected == false) {
                drawImageBlock(imgBlock);
            }
        }
    }
    function drawImageBlock(imgBlock) {
        drawFinalImage(imgBlock.no, imgBlock.x, imgBlock.y, BLOCK_WIDTH, BLOCK_HEIGHT);
    }
    function drawFinalImage(index, destX, destY, destWidth, destHeight) {
        ctx.save();
        var srcX = (index % TOTAL_COLUMNS) * IMG_WIDTH;
        var srcY = Math.floor(index / TOTAL_COLUMNS) * IMG_HEIGHT;
        ctx.drawImage(image1, srcX, srcY, IMG_WIDTH, IMG_HEIGHT, destX, destY, destWidth, destHeight);
        ctx.restore();
    }
    function drawImage(image) {
        ctx.save();
        ctx.drawImage(image, 0, 0, BLOCK_WIDTH, BLOCK_WIDTH, 10, 10, BLOCK_WIDTH, BLOCK_WIDTH);
        ctx.restore();
    }
    var interval = null;
    var remove_width;
    var remove_height;


    function handleOnMouseDbClick(e) {
        // selectedBlock = GetImageBlock(e.pageX, e.pageY);
        //alert("clicked");
    }
    function handleOnMouseOut(e) {
        // remove old selected
        if (selectedBlock != null) {
            imageBlockList[selectedBlock.no].isSelected = false;
            selectedBlock = null;
            DrawGame();
        }
    }
    function handleOnMouseDown(e) {
        // remove old selected
        if (selectedBlock != null) {
            imageBlockList[selectedBlock.no].isSelected = false;
        }
        selectedBlock = GetImageBlock(imageBlockList, e.pageX-100, e.pageY-200);
        if (selectedBlock) {
            imageBlockList[selectedBlock.no].isSelected = true;
        }
    }
    function handleOnMouseUp(e) {
        if (selectedBlock) {
            var index = selectedBlock.no;
            //   alert(index);
            var block = GetImageBlock(blockList, e.pageX-100, e.pageY-200);
            if (block) {
                var blockOldImage = GetImageBlockOnEqual(imageBlockList, block.x, block.y);
                if (blockOldImage == null) {
                    imageBlockList[index].x = block.x;
                    imageBlockList[index].y = block.y;
                }
            }
            else {
                imageBlockList[index].x = selectedBlock.x;
                imageBlockList[index].y = selectedBlock.y;
            }
            imageBlockList[index].isSelected = false;
            selectedBlock = null;
            DrawGame();
            if (isFinished()) {
                var tb1 = document.getElementById('fill'+counter);
                tb1.disabled = false;
                btnValider.disabled=false;
                btnValider.setAttribute('style', "color:#000000");
                //OnFinished();
            }
        }
    }
    function handleOnMouseMove(e) {
        if (selectedBlock) {
            selectedBlock.x = e.pageX-150;
            selectedBlock.y = e.pageY - 250;
            DrawGame();
        }
    }


    function clear(c) {
        c.clearRect(0, 0, canvas.width, canvas.height);
    }
    function randomXtoY(minVal, maxVal, floatVal) {
        var randVal = minVal + (Math.random() * (maxVal - minVal));
        var val = typeof floatVal == 'undefined' ? Math.round(randVal) : randVal.toFixed(floatVal);
        return Math.round(val);
    }
    function GetImageBlock(list, x, y) {
        //for (var i = 0; i < list.length; i++) {
        for (var i = list.length - 1; i >= 0; i--) {
            var imgBlock = list[i];
            var x1 = imgBlock.x;
            var x2 = x1 + BLOCK_WIDTH;
            var y1 = imgBlock.y;
            var y2 = y1 + BLOCK_HEIGHT;
            if (
                (x >= x1 && x <= x2) &&
                (y >= y1 && y <= y2)
            ) {
                //console.log("found: " + imgBlock.no);
                var img = new imageBlock(imgBlock.no, imgBlock.x, imgBlock.y);
                //drawImageBlock(img);
                return img;
            }
        }
        return null;
    }
    function GetImageBlockOnEqual(list, x, y) {
        for (var i = 0; i < list.length; i++) {
            var imgBlock = list[i];
            var x1 = imgBlock.x;
            var y1 = imgBlock.y;
            if (
                (x == x1) &&
                (y == y1)
            ) {
                var img = new imageBlock(imgBlock.no, imgBlock.x, imgBlock.y);
                //drawImageBlock(img);
                return img;
            }
        }
        return null;
    }
    function isFinished() {
        var total = TOTAL_PIECES;
        for (var i = 0; i < total; i++) {
            var img = imageBlockList[i];
            var block = blockList[i];
            if (
                (img.x != block.x) ||
                (img.y != block.y)
                ) {
                return false;
            }
        }
        return true;
    }
}
